/* -LICENSE-START-
 ** Copyright (c) 2015 Blackmagic Design
 **
 ** Permission is hereby granted, free of charge, to any person or organization
 ** obtaining a copy of the software and accompanying documentation covered by
 ** this license (the "Software") to use, reproduce, display, distribute,
 ** execute, and transmit the Software, and to prepare derivative works of the
 ** Software, and to permit third-parties to whom the Software is furnished to
 ** do so, all subject to the following:
 **
 ** The copyright notices in the Software and this entire statement, including
 ** the above license grant, this restriction and the following disclaimer,
 ** must be included in all copies of the Software, in whole or in part, and
 ** all derivative works of the Software, unless such copies or derivative
 ** works are solely in the form of machine-executable object code generated by
 ** a source language processor.
 **
 ** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 ** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 ** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 ** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 ** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 ** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 ** DEALINGS IN THE SOFTWARE.
 ** -LICENSE-END-
 */
#include <QPainter>
#include <QString>

#include "CommonWidgets.h"
 
FlatImageButton::FlatImageButton(const QString& imageName, QWidget* parent):
	QAbstractButton(parent),
	m_normal(QPixmap(imageName))
{
	resizeToFit(m_normal);
}

FlatImageButton::FlatImageButton(const QPixmap& image, QWidget* parent):
	QAbstractButton(parent),
	m_normal(image)
{
	resizeToFit(m_normal);
}

void FlatImageButton::resizeToFit(const QPixmap& pixmap)
{
	setFixedSize(pixmap.size() / pixmap.devicePixelRatio());
	update();
}

FlatImageButton::FlatImageButton(QWidget* parent):
	QAbstractButton(parent)
{}

void FlatImageButton::setImage(const QString& imageName)
{
	setImage(QPixmap(imageName));
}

void FlatImageButton::setImage(const QPixmap& image)
{
	m_normal = image;
	resizeToFit(m_normal);
}

void FlatImageButton::setHoverImage(const QString& imageName)
{
	m_hover = QPixmap(imageName);
}

void FlatImageButton::setHoverImage(const QPixmap& image)
{
	m_hover = image;
}

void FlatImageButton::setHoverBackgroundImage(const QString& imageName)
{
	m_hoverBackground = QPixmap(imageName);
}

void FlatImageButton::setPressedImage(const QString& imageName)
{
	m_pressed = QPixmap(imageName);
}

void FlatImageButton::setPressedImage(const QPixmap& image)
{
	m_pressed = image;
}

void FlatImageButton::setCheckedImage(const QString& imageName)
{
	m_checked = QPixmap(imageName);
}

void FlatImageButton::setCheckedImage(const QPixmap& image)
{
	m_checked = image;
}

void FlatImageButton::paintEvent(QPaintEvent*)
{
	QPainter painter(this);

	if (!isEnabled())
	{
		if (!m_normal.isNull())
			painter.drawPixmap(0, 0, m_normal);
		return;
	}

	if (! m_hoverBackground.isNull() && underMouse())
		painter.drawPixmap(0, 0, m_hoverBackground);

	if (! m_pressed.isNull() && isDown())
		painter.drawPixmap(0, 0, m_pressed);
	else if (! m_hover.isNull() && underMouse())
		painter.drawPixmap(0, 0, m_hover);
	else if (! m_checked.isNull() && isChecked())
		painter.drawPixmap(0, 0, m_checked);
	else if (! m_normal.isNull())
		painter.drawPixmap(0, 0, m_normal);
}

void FlatImageButton::enterEvent(QEvent* event)
{
	QAbstractButton::enterEvent(event);
	if (! m_hover.isNull() || ! m_hoverBackground.isNull())
		update();
}

void FlatImageButton::leaveEvent(QEvent* event)
{
	QAbstractButton::leaveEvent(event);
	if (! m_hover.isNull() || ! m_hoverBackground.isNull())
		update();
}

void FlatImageButton::setData(const QVariant& data)
{
	m_data = data;
}

const QVariant& FlatImageButton::data() const
{
	return m_data;
}
